function [DenInt,DenImg,DecImg,DecAdd,DeconvImg] = DenoiseInt(handles)
% Sums up the counts per spectra without padding (for obvious reason)
% to denoise the 2D intensity map

global tracer

if isempty(tracer)
    tracer=1;
else
    DenImg = [];
    DenInt = [];
    DecImg = [];
    DecAdd = [];
    DeconvImg = [];
    clearvars -except DenInt DenImg DecImg DecAdd DeconvImg
    return
end

%% Get Handles
IntIter   = str2double(get(handles.IntIter,'String'));
GPU       =            get(handles.GPU    ,'Value');
Factor1   = str2double(get(handles.IntFac1 ,'String'));
Factor2   = str2double(get(handles.IntFac2 ,'String'));
Norm      = get(handles.ShowInt,'UserData');


%% Get Noise parameters
SpecBin      = str2double(get(handles.SpecBinning,'String'));
Gain         = str2double(get(handles.GainVal,'String'));
IntDev       = str2double(get(handles.IntDev,'String'))/100;

ReadFull     = str2double(get(handles.ReadFull,'String'));

%% Load File
image     = load(fullfile(tempdir,'ShowOrg.mat')).image;
DecImg    = load(fullfile(tempdir,'ShowDeconv.mat')).DeconvImg;
DeconvImg = load(fullfile(tempdir,'ShowDecSub.mat')).DeconvImg;
DecAdd    = load(fullfile(tempdir,'DecAdd.mat')).DecAdd;


if ~isempty(DecImg)
    DecImg = DecImg./Norm;
    DecAdd = DecAdd./Norm;
    Dec    = 1;
else
    Dec    = 0;
end

if ~isempty(DeconvImg)
    DeconvImg = DeconvImg./Norm;
    DecSub    = 1;
else
    DecSub    = 0;
end

%% Estimate in Spacial Directions
FullVAR      = ReadFull.^2.*size(image,3).*SpecBin./2048; 

Int          = sum(image,3);

PoissonNoise = (1+IntDev.^2./4).*Gain.*Int   ;
BeamNoise    =              IntDev.^2.*Int.^2;
DetecNoise   =                     FullVAR   ;

NoiseEst_XY  = sqrt(mean(PoissonNoise + BeamNoise + DetecNoise,'all'))

%% Parameter for Denoising Algorithm
lambda1     = Factor1/(2.*NoiseEst_XY);
lambda2     = Factor2/(2.*NoiseEst_XY);

%% Denoising
tic;
try
    switch GPU
        case 1
            [DenInt,IntIter] = gpu_DenEELSInt(Int,(1+IntDev.^2./4).*Gain,FullVAR,IntDev,lambda1,lambda2,IntIter);
        otherwise
            [DenInt,IntIter] =     DenEELSInt(Int,(1+IntDev.^2./4).*Gain,FullVAR,IntDev,lambda1,lambda2,IntIter);
    end
catch
    switch GPU
        case 1
            msgbox('Not enough RAM on GPU!')
        otherwise
            msgbox('Not enough RAM!')
    end
    DenInt=[];
end
toc;
if isempty(DenInt)
    DenImg = [];
    DecImg = [];
    DecAdd = [];
    DeconvImg = [];
    clearvars -except DenInt DenImg DecImg DecAdd DeconvImg
    clear global
    return
end

DenImg     = image./sum(image,3).*DenInt;

if Dec
    DecImg = DecImg.*repmat(DenInt,[1,1,size(DecImg,3)]);
    DecAdd = DecAdd.*repmat(DenInt,[1,1,size(DecAdd,3)]);
end

if DecSub
    DeconvImg = DeconvImg.*repmat(DenInt,[1,1,size(DecImg,3)]);
end

%% Create Log entry
DenIntLog = {['DenInt: NoiseModel: MPG | Iter: ' , num2str(IntIter) , '  |  Noise Sigma: ' , num2str(sqrt(FullVAR)) ,'  |  UserFactor1: ' ,num2str(Factor1),'  |  UserFactor2: ' ,num2str(Factor2),'  |  GainVal: ' ,num2str(Gain)]};

save(fullfile(tempdir,'DenIntLog.mat'),'DenIntLog');

clearvars -except DenInt DenImg DecImg DecAdd DeconvImg
end
